﻿using System;
using Microsoft.SharePoint.Client;

namespace CreateList
{
   class Program
   {
      static void Main(string[] args)
      {
         ClientContext ctx = new ClientContext("http://contoso.de");

         // Collection sämtlicher Listen
         ListCollection lists = ctx.Web.Lists;

         // Neue Liste erzeugen
         ListCreationInformation listCreationInfo = new ListCreationInformation()
         {
            Url = "Orders",
            Title = "Bestellungen",
            Description = "In dieser Liste werden Bestellungen verwaltet",
            TemplateType = (int)ListTemplateType.GenericList,
            QuickLaunchOption = QuickLaunchOptions.On,
         };

         List newList = lists.Add(listCreationInfo);

         ctx.Load(newList,
            list => list.Title,
            list => list.Created);

         ctx.ExecuteQuery();

         Console.WriteLine("Liste erfolgreich erstellt: {0} ({1})",
            newList.Title, newList.Created);

         // Listen für Nachschlagefelder laden
         List customerList = ctx.Web.Lists.GetByTitle("Kunden");
         List articleList = ctx.Web.Lists.GetByTitle("Artikel");

         // Nur die IDs der Listen berücksichtigen
         ctx.Load(customerList, l => l.Id);
         ctx.Load(articleList, l => l.Id);

         ctx.ExecuteQuery();

         // Schema für Kunden Lookup definieren
         string customerLookupSchema = String.Format(
               @"<Field
	                  Type='Lookup'
	                  Name='Kunde'
	                  DisplayName='Kunde'
	                  Required='FALSE'
	                  EnforceUniqueValues='FALSE'
	                  List='{0}'
	                  ShowField='Kunde'
	                  UnlimitedLengthInDocumentLibrary='FALSE'
	                  Indexed='TRUE'
	                  RelationshipDeleteBehavior='Restrict'  />",
               customerList.Id);

         // Kundenspalte erstellen
         Field fieldCustomerLookup = newList.Fields.AddFieldAsXml(
            customerLookupSchema,
            true,
            AddFieldOptions.DefaultValue);

         // Schema für Artikel Lookup-Spalte definieren
         string articleLookupSchema = String.Format(
               @"<Field
	                  Type='Lookup'
	                  Name='Artikel'
	                  DisplayName='Artikel'
	                  Required='FALSE'
	                  EnforceUniqueValues='FALSE'
	                  List='{0}'
	                  ShowField='Artikel'
	                  UnlimitedLengthInDocumentLibrary='FALSE'
	                  Indexed='TRUE'
	                  RelationshipDeleteBehavior='Restrict'  />",
               articleList.Id);

         // Artikelspalte erstellen
         Field fieldArticleLookup = newList.Fields.AddFieldAsXml(
            articleLookupSchema,
            true,
            AddFieldOptions.DefaultValue);

         ctx.ExecuteQuery();

         // Spalte Liefertermin definieren
         Field fieldDate = newList.Fields.AddFieldAsXml(
             @"<Field
                  Name='Liefertermin'
                  DisplayName='Liefertermin'
                  Type='DateTime'
                  Format='DateTime'/>",
             true, AddFieldOptions.DefaultValue);

         // Spalte Lieferdatum definieren
         Field fieldAmount = newList.Fields.AddFieldAsXml(
             @"<Field
                  Name='Menge'
                  DisplayName='Menge'
                  Type='Number'/>",
             true, AddFieldOptions.DefaultValue);

         ctx.Load(fieldCustomerLookup);
         ctx.Load(fieldArticleLookup);
         ctx.Load(fieldDate);
         ctx.Load(fieldAmount);

         ctx.ExecuteQuery();

         Console.WriteLine("Spalten erfolgreich erstellt!");
         Console.WriteLine("> {0} ({1})",
            fieldCustomerLookup.InternalName, fieldCustomerLookup.TypeAsString);
         Console.WriteLine("> {0} ({1})",
            fieldArticleLookup.InternalName, fieldArticleLookup.TypeAsString);
         Console.WriteLine("> {0} ({1})",
            fieldDate.InternalName, fieldDate.TypeAsString);
         Console.WriteLine("> {0} ({1})",
            fieldAmount.InternalName, fieldAmount.TypeAsString);
      }
   }
}